<?php
// Include session config first to ensure consistent session handling
require_once "session_config.php";
require_once "config.php";

// Store any session data you might need before destroying
$redirect = "index";

// Completely destroy the session
$_SESSION = array();

// If it's desired to kill the session, also delete the session cookie.
// Note: This will destroy the session, and not just the session data!
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(
        session_name(),
        '',
        time() - 42000,
        $params["path"],
        $params["domain"],
        $params["secure"],
        $params["httponly"]
    );
}

// Finally, destroy the session
session_destroy();

// Log the logout action (optional)
error_log("User logged out. Session destroyed.");
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Logging Out</title>
    <!-- Include the SweetAlert CDN link -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body {
            margin: 0;
            padding: 0;
            background: #f2f3f8;
            font-family: 'Inter', sans-serif;
        }
        .loading {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            text-align: center;
        }
        .spinner {
            border: 4px solid rgba(0, 0, 0, 0.1);
            border-radius: 50%;
            border-top: 4px solid #3498db;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="loading">
        <div class="spinner"></div>
        <p>Logging out...</p>
    </div>
    
    <script>
    // Show success message and redirect
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            title: "Logout Successful!",
            text: "You have been logged out successfully.",
            icon: "success",
            confirmButtonText: "OK",
            allowOutsideClick: false,
            allowEscapeKey: false,
            showConfirmButton: true
        }).then((result) => {
            if (result.isConfirmed || result.dismiss === Swal.DismissReason.backdrop) {
                // Clear any remaining localStorage/sessionStorage if needed
                localStorage.removeItem('user_data');
                sessionStorage.clear();
                
                // Redirect to login page
                window.location.href = "<?php echo $redirect; ?>";
            }
        });
        
        // Auto-redirect after 5 seconds as fallback
        setTimeout(function() {
            window.location.href = "<?php echo $redirect; ?>";
        }, 5000);
    });
    </script>
</body>
</html>